#include "core.hlsl"
#include "scene.h"
#include "radiance_caching.h"

cbuffer g_lubo { radiance_caching_ubo_t g_lubo; };
RWTexture2DArray<uint2> g_prim_id;
RWTexture2DArray<uint> g_mat_id;
RWTexture2DArray<float2> g_bary;
RWTexture2DArray<float4> g_display_colour;
RWTexture2DArray<float> g_depth;
RWTexture2DArray<float2> g_mv;
RWTexture2DArray<float4> g_rt_voxel;

#include "bindings.hlsl"
#include "gltf.hlsl"
#include "scene.hlsl"
#include "pathtracer.hlsl"

#ifdef RGEN
// clang-format off
[shader("raygeneration")]
void main()
{
    // clang-format on
    uint3 LaunchID = DispatchRaysIndex();
    uint3 res = dim3(g_display_colour);
    uint3 LaunchSize = DispatchRaysDimensions();
    seed = tea(LaunchID.z * (LaunchSize.x * LaunchSize.y) + LaunchID.y * LaunchSize.x + LaunchID.x, g_lubo.random_seed);

    /*****************************************************************************/
    /* generate primary ray */
    float2 sample_uv = g_lubo.jitter;
    CameraState cam = g_lubo.cam[LaunchID.z];
    RayDesc rayDesc;
    rayDesc.Origin = cam.makeRayOrigin();
    rayDesc.TMin = 0;
    rayDesc.TMax = TMAX;
    rayDesc.Direction = cam.makeRayDirection(LaunchID.xy, res.xy, sample_uv);
    Payload payload = make_payload(rayDesc.Origin, rayDesc.Direction);

    TraceRay(g_topLevel, path_ray_flags, 0xff, 0, 1, 0, rayDesc, payload);
    LocalGeometry lg = get_local_geometry(payload.instance_id, payload.prim_id, payload.bary);
    bool hits_scene = payload.instance_id != UINT_MAX;

    /*****************************************************************************/
    /* store primary hit info */
    g_display_colour[LaunchID] = hits_scene ? float4(0, 0, 0, 1) : float4(getEnvColor(g_ubo.env, rayDesc.Direction, true, 0.0f), 1.0f);
    g_prim_id[LaunchID] = uint2(payload.instance_id, payload.prim_id);
    g_mat_id[LaunchID] = payload.mat_id;
    g_bary[LaunchID] = payload.bary;
    g_depth[LaunchID] = g_lubo.cam[LaunchID.z].worldToScreenUv(lg.pos).z;

    transform_buffer_entry_t transform = get_transform(payload.instance_id);
    float3 stable_hitpoint = cam.makeRayOrigin() + payload.t * cam.makeRayDirection(LaunchID.xy, LaunchSize.xy, 0.5);
    float3 local_stable_hitpoint = mul(transform.world_to_object, float4(stable_hitpoint, 1));
    float3 previous_hitpoint = mul(transform.previous_object_to_world, float4(local_stable_hitpoint, 1.0f));
    float2 screenUV = g_lubo.old_cam[LaunchID.z].worldToScreenUv(previous_hitpoint).xy;
    float2 mv = screenUVToMV(LaunchID.xy, LaunchSize.xy, screenUV);
    g_mv[LaunchID] = mv;
}
#endif // RGEN
