#ifndef _RADIANCE_CACHING_POLYGLOT_H_
#define _RADIANCE_CACHING_POLYGLOT_H_

#ifdef __cplusplus
// Hlsl can be really annoying about nested includes, so only include for cpp here.
#include "common.h"
#include "scene.h"
namespace render
{
#endif

struct radiance_caching_ubo_t
{
    uint32_t sample_idx DEFAULT_TO({});
    uint32_t random_seed DEFAULT_TO({});
    VEC2 jitter DEFAULT_TO({});
    UVEC3 display_res DEFAULT_TO({});
    UVEC3 screen_cache_res DEFAULT_TO({});
    float spatial_lod_bias DEFAULT_TO(0);
    uint32_t hash_map_run_length DEFAULT_TO(32);
    uint32_t hash_map_cell_lifetime DEFAULT_TO(32);
    uint32_t hash_block_size_exp DEFAULT_TO(0u);
    uint32_t screen_space_num_layers DEFAULT_TO(8);
    uint32_t screen_M DEFAULT_TO(4);
    float screen_space_target_density DEFAULT_TO(4);
    float screen_space_density_tolerance DEFAULT_TO(2);
    float screen_space_shading_rate DEFAULT_TO(0.70f);
    uint32_t screen_space_cell_lifetime DEFAULT_TO(8);
    float max_sample_history DEFAULT_TO(0);
    uint32_t max_shading_work DEFAULT_TO(1000);
    N_ARRAY(CameraState, 2, cam) DEFAULT_TO({});
    N_ARRAY(CameraState, 2, old_cam) DEFAULT_TO({});
#ifdef __cplusplus
    static size_t alignment()
    {
        const size_t alignment_mat4x4 = 16U;
        return alignment_mat4x4;
    }
#endif
};

static const float importance_min_val = 0.0f;
static const float importance_max_val = 1.0f;
static const uint32_t num_bins = 13;
static const uint32_t max_num_bins = 1024;

struct shading_statistics_t
{ 
    int32_t lowest_bin DEFAULT_TO(std::bit_cast<int32_t>(importance_max_val));
    int32_t highest_bin DEFAULT_TO(std::bit_cast<int32_t>(importance_min_val));
    uint32_t num_dispatched DEFAULT_TO(0u);
    int32_t bins[num_bins];
    uint32_t pad[max_num_bins-(num_bins+3)];
};

#define max_num_samples_per_pixel 16

static const uint32_t SINGLE_SAMPLING = 0;
static const uint32_t MULTI_SAMPLING = 1;
static const uint32_t ADAPTIVE_SAMPLING = 2;

static const uint32_t SINGLE_SHADING = 0;
static const uint32_t MULTI_SHADING = 1;
static const uint32_t ADAPTIVE_SHADING = 2;

// layout in memory!
// bary_x: 24bit (unorm)
// bary_y: 24bit (unorm)
// mat_id: 16bit (uint)
// instance_id: 32bit (uint)
// prim_id: 32bit (uint)
// stored in 128bits of float4
static const UVEC3 sample_entry_dims_fh = UVEC3(1, 1, 1);
static const UVEC3 sample_entry_dims_diffuse = UVEC3(2, 1, 1);


struct hybrid_cache_entry_t
{
    uint32_t instance;
    uint32_t prim;
    uint32_t hash_cell;
    VEC2 bary;
#if defined(__HLSL_VERSION)
    void init()
    {
        prim = 0;
        hash_cell = 0;
        bary = 0.0f;
    }
#endif
};

static const UVEC3 M_mask = UVEC3(4, 4, 1);

static const UVEC2 shade_block = UVEC2(4,4);
static const bool histogram_sum_kernel = false;

// layout float4 diffuse, float4 glossy[2], float4 out_dir[2]
#define HASH_CACHE_TEXTURE_TYPE vk::ImageType::e2D
#define HASH_CACHE_ARRAYED true
#define HASH_CACHE_SHADER_TEXTURE_TYPE RWTexture2DArray
#define HASH_MASK_SHADER_TYPE uint64_t
#define HASH_MASK_TYPE vk::Format::eR64Uint
static const UVEC3 hash_mask_cell_dims = UVEC3(1, 1, 1);
static const UVEC3 hash_cell_diffuse_dims = UVEC3(1, 1, 1);
static const UVEC3 hash_cell_glossy_dims = UVEC3(1, 5, 1);
static const UVEC3 hash_cell_diffuse_offset = UVEC3(0, 0, 0);
static const UVEC3 hash_cell_glossy0_offset = UVEC3(0, 1, 0);
static const UVEC3 hash_cell_glossy1_offset = UVEC3(0, 2, 0);
static const UVEC3 hash_cell_normal0_offset = UVEC3(0, 3, 0);
static const UVEC3 hash_cell_normal1_offset = UVEC3(0, 4, 0);

#ifdef __cplusplus
}
#endif

#endif // _RADIANCE_CACHING_POLYGLOT_H_