#pragma once

struct cached_radiance_t
{
    float4 ambient;
    float4 diffuse;
    float4 gloss[2];
    float4 out_dir[2];
};

cached_radiance_t init_cached_radiance()
{
    cached_radiance_t radiance;
    radiance.ambient = 0.0f;
    radiance.diffuse = 0.0f;
    radiance.gloss[0] = 0.0f;
    radiance.gloss[1] = 0.0f;
    radiance.out_dir[0] = 0.0f;
    radiance.out_dir[1] = 0.0f;
    return radiance;
}

float4 temporal_filter(float4 c0, float4 c1, uint max_hist)
{
    if (max_hist == 1)
        return c1;
    float min_a = max_hist > 0 ? 1.0f / max_hist : 0.0;
    float t = max(min_a, c1.a / (c0.a + c1.a));
    float new_spp = t > min_a ? c0.a + c1.a : (c0.a * c1.a) / (sqr(t) * c0.a + sqr(1 - t) * c1.a);
    float4 c2 = float4(lerp(c0.rgb, c1.rgb, t), new_spp);
    return c2;
}

shading_statistics_t histogram_postsum(
    uint frame_idx,
    uint3 img_res,
    shading_statistics_t stats
)
{
    int sum = uint(1.0 / (shade_block.x * shade_block.y) * (img_res.x * img_res.y * img_res.z));
    for (uint i = 0; i < num_bins; i++)
    {
        int b = stats.bins[i];
        sum += b;
        stats.bins[i] = sum;
    }
    return stats;
}