[[vk::constant_id(0)]] const int highlight_cache_misses = 0;
[[vk::constant_id(1)]] const int jitter_cache_cell = 0;
[[vk::constant_id(2)]] const int adjust_hash_lod_by_normal = 0;
[[vk::constant_id(3)]] const int cache_glossy = 0;

#include "core.hlsl"
#include "scene.h"
#include "radiance_caching.h"

cbuffer g_lubo { radiance_caching_ubo_t g_lubo; };
Texture2DArray<uint2> g_prim_id;
Texture2DArray<uint> g_mat_id;
Texture2DArray<float2> g_bary;
HASH_CACHE_SHADER_TEXTURE_TYPE<HASH_MASK_SHADER_TYPE> g_hash_mask;
HASH_CACHE_SHADER_TEXTURE_TYPE<float4> g_hash_cache;
RWTexture2DArray<float4> g_display_colour;
RWTexture2DArray<float4> g_dbg;

#include "bindings.hlsl"
#include "gltf.hlsl"
#include "scene.hlsl"
#include "pathtracer.hlsl"
#include "common.hlsl"
#include "radiance_caching.hlsl"
#include "hash_cache.hlsl"


#ifdef RGEN
// clang-format off
[shader("raygeneration")]
void main()
{
    // clang-format on
    const uint3 display_res = g_lubo.display_res;
    uint3 LaunchID = DispatchRaysIndex();
    const uint3 LaunchSize = DispatchRaysDimensions();

    LaunchID.z = g_lubo.sample_idx % display_res.z ? (1 - LaunchID.z) : LaunchID.z;

    seed = tea(
        g_lubo.sample_idx * (LaunchSize.x * LaunchSize.y * LaunchSize.z) + LaunchID.z * (LaunchSize.x * LaunchSize.y)
            + LaunchID.y * LaunchSize.x + LaunchID.x,
        g_ubo.generation
    ) + 2938674;

    const CameraState cam = g_lubo.cam[LaunchID.z];
    const float3 origin = cam.makeRayOrigin();
    const float coneDiff = cam.getConeDiff(display_res.xy);

    // read primary hit
    uint2 id_val = g_prim_id[LaunchID];
    uint instance_id = id_val.x;
    uint prim_id = id_val.y;
    uint mat_id = g_mat_id[LaunchID];
    float2 bary = g_bary[LaunchID];
    const LocalGeometry lg = get_local_geometry(instance_id, prim_id, bary);
    if (instance_id == UINT_MAX)
        return;

    // compute LoD and direction
    const float3 out_dir = normalize(lg.pos - origin);
    float lod = log2(coneDiff * length(origin - lg.pos));
    if (adjust_hash_lod_by_normal)
        lod -= log2(abs(dot(out_dir, lg.surface_normal)));

    const float tex_lod = lod - log2(sqrt(32));
    const GltfShadeParams sp = get_shading_params(mat_id, out_dir, tex_lod, lg);

    // cache lookup
    cache_query_t query;
    query.sample_idx = g_lubo.sample_idx;
    query.hash_map_run_length = g_lubo.hash_map_run_length;
    query.hash_map_cell_lifetime = g_lubo.hash_map_cell_lifetime;
    query.hash_map_block_exp = g_lubo.hash_block_size_exp;
    query.use_dir = false;
    query.use_normal = true;
    query.instance_id = instance_id;
    query.local_pos = lg.local_pos;
    query.lod = lod + g_lubo.spatial_lod_bias;
    query.dir = out_dir;
    query.roughness = sp.roughness;
    query.normal = dot(-out_dir, sp.normal) > 0 ? -sp.normal : sp.normal;

    uint jitter_idx = ((LaunchID.y % 3) * 3 + LaunchID.x % 3 + g_lubo.sample_idx) % 16;
    if (jitter_cache_cell)
        query = jitter_cache_query(jitter_idx, query);

    cache_query_result_t qresult = hash_cache_lookup(g_hash_mask, g_hash_cache, true, query);
    const bool update_entry = qresult.cache_idx.x != UINT_MAX;

    // mask cache_misses
    if (highlight_cache_misses && (qresult.cache_miss || qresult.radiance.diffuse.a == 0.0f))
        g_display_colour[LaunchID] = float4(0, HLSL_FLT_MAX, HLSL_FLT_MAX, 1);

    float4 new_diffuse = float4(0, 0, 0, 1);
    float4 new_glossy = float4(0, 0, 0, 1);
    const float3 diffuse_albedo = sp.lambertian_weight(0.0) * sp.base_color.rgb;
    float3 glossy_albedo = 0.0f;

    if (cache_glossy)
        glossy_albedo = max(0.1, (sp.metallic_weight() + sp.specular_reflection_weight(1)) * sp.base_color.rgb); 

    if (update_entry)
    {
        float2x4 direct_light = compute_direct_light(g_ubo.max_bounces, g_ubo.env, lg, out_dir, sp, cache_glossy, true);
        new_diffuse.rgb += direct_light[0].rgb / max(diffuse_albedo, albedo_eps);
        new_glossy.rgb += direct_light[1].rgb / max(glossy_albedo, albedo_eps);

        float2x4 indirect_light = compute_indirect_light(g_ubo.max_bounces, g_ubo.env, lg, out_dir, coneDiff, lod, sp, cache_glossy);
        new_diffuse.rgb += indirect_light[0].rgb / max(diffuse_albedo, albedo_eps);
        new_glossy.rgb += indirect_light[1].rgb / max(glossy_albedo, albedo_eps);
    }
    new_diffuse.rgb = clip_fireflies(new_diffuse.rgb);
    new_glossy.rgb = clip_fireflies(new_glossy.rgb);

    float3 old_out_dir = normalize(get_old_local_geometry(instance_id, prim_id, bary).pos - g_lubo.old_cam[LaunchID.z].makeRayOrigin());
    cached_radiance_t cached_radiance = update_hash_cache_entry(
        LaunchID.z,
        g_lubo.max_sample_history,
        g_hash_cache,
        qresult,
        query.roughness,
        new_diffuse,
        new_glossy,
        out_dir,
        old_out_dir
    );

    g_display_colour[LaunchID].rgb += diffuse_albedo * cached_radiance.diffuse.rgb;
    if (cache_glossy)
        g_display_colour[LaunchID].rgb += glossy_albedo * cached_radiance.gloss[LaunchID.z].rgb;
}

#endif // RGEN
