# Using the tool

This is a prototype implementation of the projection semantics described in Cryptographic Choreographies.
Running "CCHaskell file.choreo" will output the local behaviours of each agent in the choreography described in file.choreo.

Further, we support translation of the generated local processes into ProVerif code, which can then be used to verify security properties of the protocol. 
The option "--pvout file.pv" will write the ProVerif code to file.pv.
The option "--runproverif" will automatically run ProVerif on the generated file. 

We also support verifying APIs, where the behaviour of an API in a choreography might be more restricted than the full behaviour of the agent implementing the API.
We support stitching together roles from multiple choreographies, e.g., one choreography describing the main protocol and another describing the API of a trusted third party, into a single ProVerif model. 
The option "-- stitch spec" where spec is of the form  "file1.choreo:main,Alice,Bob;file2.choreo:ttp" will pick the front-matter(main), Alice and Bob roles from file1.choreo and the ttp role from file2.choreo.

# Compiling from source

If Cabal is installed and well-configured, "cabal build" should work out of the box.
"cabal test" will run the test suite.



# WARNING 
**This tool is work-in-progress, and not all well-formedness checks have been implemented yet.**

In particular, the input to the tool must satisfy the following conditions:
- Each variable is bound at most once in each branch (note that read operations bind variables that are not bound already, but do not re-bind existing variables)
- All free variables are agents. 
- No reserved names are used for variables or user-defined functions. These include (but are not limited to):
    - l1, l2, ...
    - crypt, dcrypt, vcrypt, scrypt, ...
    - bitstring, agent, skey, key, ...
    - agent2bitstring, bitstring2agent, ...
    - atomic_lock, atomic_baton, branch
    - i, ic, c
    - endweakauth0, endweakauth1, ..., beginstrongauth0, beginstrongauth1, ...
    - secret0, secret1, ...
    - ...
- The choreography types (all function calls have the correct number of arguments, etc.)
- There is at most one read and one write operation to each-cell family per atomic block, and if both are present, they must be to the same address. 