{-

CryptoChoreo 2026

(C) Copyright Simon Tobias Lund 2026
(C) Copyright Sebastian Alexander Mödersheim 2026
(C) Copyright Technical University of Denmark 2026

All Rights Reserved.

-}
module ProtocolSetup (protocolSetup) where

-- | ProVerif protocol setup definitions
-- This includes type definitions, cryptographic primitives, and standard functions
protocolSetup :: String
protocolSetup = unlines
  [ "free ic: channel."
  , "free c: channel."
  , ""
  , "type agent."
  , "fun agent2bitstring(agent): bitstring [typeConverter]."
  , ""
  , "free i: agent."
  , ""
  , "type skey."
  , "fun skey2bitstring(skey): bitstring [typeConverter]."
  , "fun skdf(bitstring): skey [typeConverter]."
  , ""
  , "fun sk(agent,agent): skey [private]."
  , "fun scrypt(bitstring,skey): bitstring."
  , "reduc forall x: bitstring, k: skey;"
  , "    dscrypt(scrypt(x,k),k) = x."
  , "fun vscrypt(bitstring,skey): bool"
  , "reduc forall x: bitstring, k: skey; vscrypt(scrypt(x,k),k) = true"
  , "otherwise forall x: bitstring, k: skey; vscrypt(x,k) = false."
  , ""
  , "type pubkey."
  , "fun pubkey2bitstring(pubkey): bitstring [typeConverter]."
  , "fun kdf(bitstring): pubkey [typeConverter]."
  , ""
  , "type privkey."
  , "fun privkey2bitstring(privkey): bitstring [typeConverter]."
  , "fun invkdf(bitstring): privkey [typeConverter]."
  , ""
  , "fun pk(agent): pubkey."
  , "fun inv(pubkey): privkey [private]."
  , "reduc forall k: pubkey;"
  , "    pubk(inv(k)) = k."
  , "reduc forall k: pubkey;"
  , "    vinv(inv(k)) = true. "
  , "fun crypt(bitstring,pubkey) : bitstring."
  , "reduc forall x: bitstring, k: pubkey; "
  , "    dcrypt(crypt(x,k),inv(k)) = x."
  , ""
  , "fun vcrypt(bitstring,privkey) : bool"
  , "reduc forall x: bitstring, k: pubkey; vcrypt(crypt(x,k),inv(k)) = true"
  , "otherwise forall x: bitstring, k: privkey; vcrypt(x,k) = false."
  , ""
  , ""
  , "fun sign(bitstring,privkey) : bitstring."
  , "reduc forall x: bitstring, k: pubkey; "
  , "    open(sign(x,inv(k)),k) = x. "
  , ""
  , "fun vsign(bitstring,pubkey) : bool"
  , "reduc forall x: bitstring, k: pubkey; vsign(sign(x,inv(k)),k) = true"
  , "otherwise forall x: bitstring, k: pubkey; vsign(x,k) = false."
  , ""
  , ""
  , "(*exp(T,X) represents T^X*)"
  , "fun exp(bitstring,bitstring): bitstring."
  , "const g: bitstring."
  , "equation forall x: bitstring, y: bitstring;"
  , "    exp(exp(g,y),x) = exp(exp(g,x),y)."
  , "(*equation forall x: bitstring, y: bitstring, z: bitstring;"
  , "    exp(exp(exp(g,z),y),x) = exp(exp(exp(g,z),x),y).*) (*Decreases performance quite a bit. Uncomment for 3-party DH*)"
  , "(*...*)"
  , "reduc forall x: bitstring, y: bitstring; "
  , "    invexp(exp(x,y),y) = x."
  , ""
  , "fun vexp(bitstring,bitstring) : bool"
  , "reduc forall x: bitstring, y: bitstring; vexp(exp(x,y),y) = true"
  , "otherwise forall x: bitstring, y: bitstring; vexp(exp(x,y),y) = false."
  , ""
  , "reduc forall x: bitstring, y: bitstring;"
  , "    fst((x,y)) = x."
  , "reduc forall x: bitstring, y: bitstring;"
  , "    snd((x,y)) = y."
  , "fun vpair(bitstring) : bool"
  , "reduc forall x: bitstring, y: bitstring; vpair((x,y)) = true"
  , "otherwise forall x: bitstring; vpair(x) = false."
  , ""
  , ""
  , "free atomic_lock: channel [private]."
  , "const atomic_baton: bitstring. "
  , ""
  ]
